/*
 * Decompiled with CFR 0.152.
 */
package com.lianda.flink.sync;

import com.lianda.flink.sync.MySqlSink;
import com.ververica.cdc.connectors.mysql.MySqlSource;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.JsonDebeziumDeserializationSchema;
import java.util.Properties;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

public class MySqlCdcSync {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        Properties properties = new Properties();
        properties.setProperty("database.server.id", "168168");
        properties.setProperty("database.server.name", "mysql-source");
        properties.setProperty("database.character.set", "utf8mb4");
        properties.setProperty("database.collation.name", "utf8mb4_unicode_ci");
        properties.setProperty("database.time_zone", "Asia/Shanghai");
        properties.setProperty("database.serverTimezone", "Asia/Shanghai");
        properties.setProperty("database.connectionTimeZone", "Asia/Shanghai");
        properties.setProperty("database.connection.properties", "useUnicode=true&characterEncoding=UTF-8&useSSL=false&serverTimezone=Asia/Shanghai&characterSetResults=utf8mb4&characterSetServer=utf8mb4");
        properties.setProperty("key.converter", "org.apache.kafka.connect.json.JsonConverter");
        properties.setProperty("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        properties.setProperty("key.converter.schemas.enable", "false");
        properties.setProperty("value.converter.schemas.enable", "false");
        properties.setProperty("key.converter.encoding", "UTF-8");
        properties.setProperty("value.converter.encoding", "UTF-8");
        properties.setProperty("binlog.row.image", "FULL");
        properties.setProperty("database.history.skip.unparseable.ddl", "true");
        properties.setProperty("debezium.source.encoding", "UTF-8");
        properties.setProperty("debezium.sink.encoding", "UTF-8");
        properties.setProperty("debezium.connector.encoding", "UTF-8");
        properties.setProperty("debezium.binlog.encoding", "UTF-8");
        properties.setProperty("debezium.mysql.encoding", "UTF-8");
        properties.setProperty("mysql.character.set", "utf8mb4");
        properties.setProperty("mysql.collation.name", "utf8mb4_unicode_ci");
        properties.setProperty("binlog.character.set", "utf8mb4");
        properties.setProperty("source.encoding", "UTF-8");
        properties.setProperty("sink.encoding", "UTF-8");
        DebeziumSourceFunction mySqlSource = MySqlSource.builder().hostname("192.168.0.77").port(3306).databaseList(new String[]{"TugboatCommon"}).tableList(new String[]{"TugboatCommon.Bus_Holiday", "TugboatCommon.Bus_ShipPaymentType", "TugboatCommon.Bus_ShipPaymentType_ShipType", "TugboatCommon.Disp_Port", "TugboatCommon.Disp_PortDictionary", "TugboatCommon.Disp_Tugboat", "TugboatCommon.Disp_DeepLevel", "TugboatCommon.Disp_Berthage", "TugboatCommon.Disp_BerthageDictionary", "TugboatCommon.Disp_Pilot", "TugboatCommon.Disp_Tugboatowner", "TugboatCommon.Disp_Waterway", "TugboatCommon.Fin_AssistCode", "TugboatCommon.Fin_AssistCodeItem", "TugboatCommon.Fin_Subject", "TugboatCommon.Fin_Subject_AssistCode", "TugboatCommon.Fin_TaxRule", "TugboatCommon.Pro_FeeItemAssistCode", "TugboatCommon.Pro_FeeItemSettings", "TugboatCommon.Sal_Holiday", "TugboatCommon.Sal_SocialInsuranceStandard", "TugboatCommon.Sal_TaxLevel", "TugboatCommon.Tug_Certificate"}).username("root").password("bowin@2023").startupOptions(StartupOptions.initial()).deserializer((DebeziumDeserializationSchema)new JsonDebeziumDeserializationSchema()).debeziumProperties(properties).build();
        DataStreamSource sourceStream = env.addSource((SourceFunction)mySqlSource);
        sourceStream.addSink((SinkFunction)new MySqlSink("192.168.0.77", 3306, "LiandaTugboatMIS", "root", "bowin@2023"));
        env.execute("MySQL CDC Data Sync");
    }
}

