/*
 * Decompiled with CFR 0.152.
 */
package com.lianda.flink.sync;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

public class MySqlSink
extends RichSinkFunction<String> {
    private String hostname;
    private int port;
    private String database;
    private String username;
    private String password;
    private Connection connection;
    private final ConcurrentMap<String, Set<String>> primaryKeysCache = new ConcurrentHashMap<String, Set<String>>();

    public MySqlSink(String hostname, int port, String database, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        Class.forName("com.mysql.cj.jdbc.Driver");
        String url = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&serverTimezone=Asia/Shanghai&characterEncoding=UTF-8&useUnicode=true&characterSetResults=utf8mb4&characterSetServer=utf8mb4", this.hostname, this.port, this.database);
        this.connection = DriverManager.getConnection(url, this.username, this.password);
        this.connection.setAutoCommit(false);
    }

    public void invoke(String value, SinkFunction.Context context) throws Exception {
        JSONObject event = JSON.parseObject((String)value);
        String op = event.getString("op");
        String table = null;
        JSONObject source = event.getJSONObject("source");
        if (source != null && (table = source.getString("table")).contains("_")) {
            String[] parts = table.split("_");
            StringBuilder properCaseTable = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    properCaseTable.append("_");
                }
                properCaseTable.append(parts[i].substring(0, 1).toUpperCase()).append(parts[i].substring(1).toLowerCase());
            }
            table = properCaseTable.toString();
            System.out.println("\u8868\u540d\u8f6c\u6362\u4e3a\u4e0b\u5212\u7ebf\u5206\u9694\u9996\u5b57\u6bcd\u5927\u5199\u683c\u5f0f: " + table);
        }
        if (table == null) {
            System.out.println("\u8df3\u8fc7\u8868\u540d\u4e3anull\u7684\u4e8b\u4ef6: " + event.toJSONString());
            return;
        }
        if ("r".equals(op)) {
            return;
        }
        try {
            if ("c".equals(op) || "u".equals(op)) {
                JSONObject after = event.getJSONObject("after");
                System.out.println("\u5904\u7406\u63d2\u5165/\u66f4\u65b0\u64cd\u4f5c\uff0c\u8868\u540d: " + table + "\uff0c\u6570\u636e: " + after.toJSONString());
                for (String key : after.keySet()) {
                    Object valueObj = after.get((Object)key);
                    if (!(valueObj instanceof String)) continue;
                    String strValue = (String)valueObj;
                    String fixedValue = this.fixEncoding(strValue);
                    if (!fixedValue.equals(strValue)) {
                        System.out.println("\u5b57\u6bb5: " + key + "\uff0c\u539f\u59cb\u503c: " + strValue + "\uff0c\u4fee\u590d\u540e: " + fixedValue + "\uff0c\u957f\u5ea6: " + fixedValue.length());
                        after.put(key, (Object)fixedValue);
                        continue;
                    }
                    System.out.println("\u5b57\u6bb5: " + key + "\uff0c\u503c: " + strValue + "\uff0c\u957f\u5ea6: " + strValue.length());
                }
                this.handleUpsert(table, after);
            } else if ("d".equals(op)) {
                JSONObject before = event.getJSONObject("before");
                System.out.println("\u5904\u7406\u5220\u9664\u64cd\u4f5c\uff0c\u8868\u540d: " + table + "\uff0c\u6570\u636e: " + before.toJSONString());
                this.handleDelete(table, before);
            }
            this.connection.commit();
        }
        catch (Exception e) {
            this.connection.rollback();
            System.err.println("\u5904\u7406\u4e8b\u4ef6\u5931\u8d25\uff0c\u8868\u540d: " + table + "\uff0c\u64cd\u4f5c: " + op);
            System.err.println("\u4e8b\u4ef6\u6570\u636e: " + event.toJSONString());
            e.printStackTrace();
            throw e;
        }
    }

    private void handleUpsert(String table, JSONObject data) throws SQLException {
        if (this.isRecordExists(table, data)) {
            this.handleUpdate(table, data);
        } else {
            this.handleInsert(table, data);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRecordExists(String table, JSONObject data) throws SQLException {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereValues = new ArrayList<Object>();
        String idField = null;
        Object idValue = null;
        if (data.containsKey((Object)"HolidayID")) {
            idField = "HolidayID";
            idValue = data.get((Object)"HolidayID");
        } else if (data.containsKey((Object)"ID")) {
            idField = "ID";
            idValue = data.get((Object)"ID");
        } else if (data.containsKey((Object)"Id")) {
            idField = "Id";
            idValue = data.get((Object)"Id");
        } else if (data.containsKey((Object)"id")) {
            idField = "id";
            idValue = data.get((Object)"id");
        }
        if (idField != null && idValue != null) {
            whereClause.append(idField).append(" = ?");
            whereValues.add(idValue);
        } else {
            for (Object entry : data.entrySet()) {
                String string = (String)entry.getKey();
                Object value = entry.getValue();
                whereClause.append(string).append(" = ? AND ");
                whereValues.add(value);
            }
            if (whereClause.length() > 0) {
                whereClause.setLength(whereClause.length() - 5);
            }
        }
        String sql = String.format("SELECT COUNT(*) FROM %s WHERE %s", table, whereClause.toString());
        System.out.println("\u6267\u884c\u68c0\u67e5\u8bb0\u5f55\u662f\u5426\u5b58\u5728\u7684\u8bed\u53e5: " + sql);
        System.out.print("\u68c0\u67e5\u53c2\u6570\u503c: [");
        for (Object e : whereValues) {
            System.out.print(e + ", ");
        }
        System.out.println("]");
        try {
            Throwable throwable = null;
            try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
                int index = 1;
                for (Object e : whereValues) {
                    this.setParameter(stmt, index++, e);
                }
                Throwable throwable2 = null;
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return false;
                    int count = rs.getInt(1);
                    System.out.println("\u8bb0\u5f55\u5b58\u5728\u68c0\u67e5\u7ed3\u679c: " + (count > 0 ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728"));
                    boolean bl = count > 0;
                    return bl;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
        }
        catch (Exception e) {
            System.err.println("\u68c0\u67e5\u8bb0\u5f55\u662f\u5426\u5b58\u5728\u5931\u8d25: " + sql);
            e.printStackTrace();
            return false;
        }
    }

    private void handleInsert(String table, JSONObject data) throws SQLException {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        boolean hasRowguid = false;
        try {
            String checkTableSql = "DESCRIBE " + table;
            try (PreparedStatement checkStmt = this.connection.prepareStatement(checkTableSql);){
                ResultSet rs = checkStmt.executeQuery();
                while (rs.next()) {
                    if (!"rowguid".equals(rs.getString("Field"))) continue;
                    hasRowguid = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u67e5\u8be2\u8868\u7ed3\u6784\u5931\u8d25: " + e.getMessage());
        }
        ArrayList originalValues = new ArrayList();
        for (Map.Entry entry : data.entrySet()) {
            String column = (String)entry.getKey();
            Object value = entry.getValue();
            columns.append(column).append(", ");
            values.append("?,");
            originalValues.add(value);
        }
        if (hasRowguid && !data.containsKey((Object)"rowguid")) {
            columns.append("rowguid, ");
            values.append("?,");
        }
        if (columns.length() > 0) {
            columns.setLength(columns.length() - 2);
            values.setLength(values.length() - 1);
        }
        String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", table, columns.toString(), values.toString());
        System.out.println("\u6267\u884cINSERT\u8bed\u53e5: " + sql);
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            int index = 1;
            System.out.print("INSERT\u53c2\u6570\u503c: [");
            for (Object value : originalValues) {
                System.out.print(value + ", ");
                this.setParameter(stmt, index++, value);
            }
            if (hasRowguid && !data.containsKey((Object)"rowguid")) {
                String rowguid = UUID.randomUUID().toString();
                System.out.print(rowguid + ", ");
                stmt.setString(index++, rowguid);
            }
            System.out.println("]");
            int affectedRows = stmt.executeUpdate();
            System.out.println("INSERT\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u884c\u6570: " + affectedRows);
        }
        catch (Exception e) {
            System.err.println("\u6267\u884cINSERT\u8bed\u53e5\u5931\u8d25: " + sql);
            e.printStackTrace();
            throw e;
        }
    }

    private void handleUpdate(String table, JSONObject data) throws SQLException {
        Object value;
        String column;
        StringBuilder setClause = new StringBuilder();
        ArrayList setValues = new ArrayList();
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereValues = new ArrayList<Object>();
        String idField = null;
        Object idValue = null;
        if (data.containsKey((Object)"HolidayID")) {
            idField = "HolidayID";
            idValue = data.get((Object)"HolidayID");
        } else if (data.containsKey((Object)"ID")) {
            idField = "ID";
            idValue = data.get((Object)"ID");
        } else if (data.containsKey((Object)"Id")) {
            idField = "Id";
            idValue = data.get((Object)"Id");
        } else if (data.containsKey((Object)"id")) {
            idField = "id";
            idValue = data.get((Object)"id");
        }
        for (Map.Entry entry : data.entrySet()) {
            column = (String)entry.getKey();
            value = entry.getValue();
            if (column.equals(idField)) continue;
            setClause.append(column).append(" = ?,");
            setValues.add(value);
        }
        if (setClause.length() > 0) {
            setClause.setLength(setClause.length() - 1);
        }
        if (idField != null && idValue != null) {
            whereClause.append(idField).append(" = ?");
            whereValues.add(idValue);
        } else {
            for (Map.Entry entry : data.entrySet()) {
                column = (String)entry.getKey();
                value = entry.getValue();
                whereClause.append(column).append(" = ? AND ");
                whereValues.add(value);
            }
            if (whereClause.length() > 0) {
                whereClause.setLength(whereClause.length() - 5);
            }
        }
        String sql = String.format("UPDATE %s SET %s WHERE %s", table, setClause.toString(), whereClause.toString());
        System.out.println("\u6267\u884cUPDATE\u8bed\u53e5: " + sql);
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            int index = 1;
            System.out.print("UPDATE\u53c2\u6570\u503c: [");
            for (Object e : setValues) {
                System.out.print(e + ", ");
                this.setParameter(stmt, index++, e);
            }
            for (Object e : whereValues) {
                System.out.print(e + ", ");
                this.setParameter(stmt, index++, e);
            }
            System.out.println("]");
            int affectedRows = stmt.executeUpdate();
            System.out.println("UPDATE\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u884c\u6570: " + affectedRows);
        }
        catch (Exception e) {
            System.err.println("\u6267\u884cUPDATE\u8bed\u53e5\u5931\u8d25: " + sql);
            e.printStackTrace();
            throw e;
        }
    }

    private Set<String> getPrimaryKeys(String table) throws SQLException {
        HashSet<String> primaryKeys = (HashSet<String>)this.primaryKeysCache.get(table);
        if (primaryKeys != null) {
            return primaryKeys;
        }
        primaryKeys = new HashSet<String>();
        DatabaseMetaData metaData = this.connection.getMetaData();
        ResultSet rs = metaData.getPrimaryKeys(null, this.database, table);
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            primaryKeys.add(columnName);
        }
        rs.close();
        this.primaryKeysCache.put(table, primaryKeys);
        return primaryKeys;
    }

    private void handleDelete(String table, JSONObject data) throws SQLException {
        Set<String> primaryKeys = this.getPrimaryKeys(table);
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> primaryKeyValues = new ArrayList<Object>();
        if (!primaryKeys.isEmpty()) {
            for (String key : primaryKeys) {
                if (!data.containsKey((Object)key)) continue;
                whereClause.append(key).append(" = ? AND ");
                primaryKeyValues.add(data.get((Object)key));
            }
        } else {
            for (Map.Entry entry : data.entrySet()) {
                String column = (String)entry.getKey();
                whereClause.append(column).append(" = ? AND ");
                primaryKeyValues.add(entry.getValue());
            }
        }
        if (whereClause.length() > 0) {
            whereClause.setLength(whereClause.length() - 5);
        }
        String sql = String.format("DELETE FROM %s WHERE %s", table, whereClause.toString());
        System.out.println("\u6267\u884cDELETE\u8bed\u53e5: " + sql);
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            int index = 1;
            System.out.print("DELETE\u53c2\u6570\u503c: [");
            for (Object e : primaryKeyValues) {
                System.out.print(e + ", ");
                this.setParameter(stmt, index++, e);
            }
            System.out.println("]");
            int affectedRows = stmt.executeUpdate();
            System.out.println("DELETE\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u884c\u6570: " + affectedRows);
        }
        catch (Exception e) {
            System.err.println("\u6267\u884cDELETE\u8bed\u53e5\u5931\u8d25: " + sql);
            e.printStackTrace();
            throw e;
        }
    }

    private void setParameter(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 0);
        } else if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.matches("\\d{13}")) {
                try {
                    long timestamp = Long.parseLong(strValue);
                    long adjustedTimestamp = timestamp - 28800000L;
                    Timestamp sqlTimestamp = new Timestamp(adjustedTimestamp);
                    stmt.setTimestamp(index, sqlTimestamp);
                    System.out.println("\u65f6\u95f4\u6233\u8c03\u6574\uff08\u5b57\u7b26\u4e32\uff09\uff1a" + timestamp + " -> " + adjustedTimestamp);
                }
                catch (NumberFormatException e) {
                    stmt.setString(index, strValue);
                }
            } else {
                stmt.setString(index, strValue);
            }
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            if (String.valueOf(longValue).length() == 13) {
                long adjustedTimestamp = longValue - 28800000L;
                Timestamp sqlTimestamp = new Timestamp(adjustedTimestamp);
                stmt.setTimestamp(index, sqlTimestamp);
                System.out.println("\u65f6\u95f4\u6233\u8c03\u6574\uff08\u957f\u6574\u578b\uff09\uff1a" + longValue + " -> " + adjustedTimestamp);
            } else {
                stmt.setLong(index, longValue);
            }
        } else if (value instanceof Integer) {
            stmt.setInt(index, (Integer)value);
        } else if (value instanceof Boolean) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            long adjustedTimestamp = date.getTime() - 28800000L;
            Timestamp sqlTimestamp = new Timestamp(adjustedTimestamp);
            stmt.setTimestamp(index, sqlTimestamp);
            System.out.println("\u65f6\u95f4\u6233\u8c03\u6574\uff08Date\uff09\uff1a" + date.getTime() + " -> " + adjustedTimestamp);
        } else {
            stmt.setObject(index, value);
        }
    }

    private String fixEncoding(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        try {
            String[] encodings;
            String fixed;
            String iso88591Str;
            byte[] utf8Bytes2;
            byte[] gbkBytes2;
            String fixed2;
            byte[] iso88591Bytes2;
            try {
                iso88591Bytes2 = str.getBytes("ISO-8859-1");
                fixed2 = new String(iso88591Bytes2, "UTF-8");
                if (this.containsChinese(fixed2)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: ISO-8859-1 -> UTF-8, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed2);
                    return fixed2;
                }
            }
            catch (Exception iso88591Bytes2) {
                // empty catch block
            }
            try {
                iso88591Bytes2 = str.getBytes("ISO-8859-1");
                fixed2 = new String(iso88591Bytes2, "GBK");
                if (this.containsChinese(fixed2)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: ISO-8859-1 -> GBK, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed2);
                    return fixed2;
                }
            }
            catch (Exception iso88591Bytes3) {
                // empty catch block
            }
            try {
                gbkBytes2 = str.getBytes("GBK");
                fixed2 = new String(gbkBytes2, "UTF-8");
                if (this.containsChinese(fixed2)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: GBK -> UTF-8, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed2);
                    return fixed2;
                }
            }
            catch (Exception gbkBytes2) {
                // empty catch block
            }
            try {
                utf8Bytes2 = str.getBytes("UTF-8");
                fixed2 = new String(utf8Bytes2, "GBK");
                if (this.containsChinese(fixed2)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: UTF-8 -> GBK, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed2);
                    return fixed2;
                }
            }
            catch (Exception utf8Bytes2) {
                // empty catch block
            }
            try {
                utf8Bytes2 = str.getBytes("UTF-8");
                iso88591Str = new String(utf8Bytes2, "ISO-8859-1");
                fixed = new String(iso88591Str.getBytes("ISO-8859-1"), "UTF-8");
                if (this.containsChinese(fixed)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: UTF-8 -> ISO-8859-1 -> UTF-8, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed);
                    return fixed;
                }
            }
            catch (Exception utf8Bytes3) {
                // empty catch block
            }
            try {
                gbkBytes2 = str.getBytes("GBK");
                iso88591Str = new String(gbkBytes2, "ISO-8859-1");
                fixed = new String(iso88591Str.getBytes("ISO-8859-1"), "UTF-8");
                if (this.containsChinese(fixed)) {
                    System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: GBK -> ISO-8859-1 -> UTF-8, \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed);
                    return fixed;
                }
            }
            catch (Exception gbkBytes3) {
                // empty catch block
            }
            for (String fromEncoding : encodings = new String[]{"ISO-8859-1", "UTF-8", "GBK", "GB2312"}) {
                for (String toEncoding : encodings) {
                    if (fromEncoding.equals(toEncoding)) continue;
                    try {
                        byte[] bytes = str.getBytes(fromEncoding);
                        String fixed3 = new String(bytes, toEncoding);
                        if (!this.containsChinese(fixed3)) continue;
                        System.out.println("\u7f16\u7801\u4fee\u590d\u6210\u529f: " + fromEncoding + " -> " + toEncoding + ", \u539f\u59cb\u503c: " + str + ", \u4fee\u590d\u540e: " + fixed3);
                        return fixed3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u7f16\u7801\u4fee\u590d\u5f02\u5e38: " + e.getMessage());
        }
        return str;
    }

    private boolean containsChinese(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.UnicodeScript.of(c) != Character.UnicodeScript.HAN) continue;
            return true;
        }
        return false;
    }

    public void close() throws Exception {
        super.close();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }
}

