/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExceptionCollector {
    private final List<Throwable> exceptions = new ArrayList<Throwable>();

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable ex) {
            this.exceptions.add(ex);
        }
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void assertEmpty() throws Exception {
        if (this.exceptions.isEmpty()) {
            return;
        }
        if (this.exceptions.size() == 1) {
            Throwable exception = this.exceptions.get(0);
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            AssertionError assertionError = new AssertionError((Object)exception.getMessage());
            ((Throwable)((Object)assertionError)).initCause(exception);
            throw assertionError;
        }
        StringBuilder message = new StringBuilder();
        message.append("Multiple Exceptions (").append(this.exceptions.size()).append("):");
        for (Throwable exception : this.exceptions) {
            message.append('\n');
            message.append(exception.getMessage());
        }
        AssertionError assertionError = new AssertionError(message);
        this.exceptions.forEach(arg_0 -> assertionError.addSuppressed(arg_0));
        throw assertionError;
    }

    @FunctionalInterface
    public static interface Executable {
        public void execute() throws Throwable;
    }
}

